const ffmpeg = require("fluent-ffmpeg");
const fs = require("fs");
const path = require("path");

/**
 * @GPT Support
 * Do not modify/delete this watermark!
 */

function VideoHD(inputPath, outputPath, callback) {
  ffmpeg(inputPath)
    .videoCodec("libx264")
    .size("1280x720")
    .on("end", () => {
      console.log("Video berhasil diubah menjadi HD.");
      callback(null, outputPath);
    })
    .on("error", (err) => {
      console.error("Terjadi kesalahan: ", err.message);
      callback(err, null);
    })
    .save(outputPath);
}

module.exports = { VideoHD };
